<?php if($paginator->hasPages()): ?>
    <nav aria-label="pagination">
        <ul class="pagination justify-content-center">
            
            <?php if($paginator->onFirstPage()): ?>
                <li class="page-item disabled"><a class="page-link"><?php echo e(__('Previous')); ?></a></li>
            <?php else: ?>
                <li class="page-item"><a class="page-link"
                        href="<?php echo e($paginator->previousPageUrl()); ?>"><?php echo e(__('Previous')); ?></a></li>
            <?php endif; ?>

            
            <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <?php if(is_string($element)): ?>
                    <li class="page-item shadow disabled"><a class="page-link active"><?php echo e($element); ?></a></li>
                <?php endif; ?>

                
                <?php if(is_array($element)): ?>
                    <?php
                        $currentPage = $paginator->currentPage();
                        $lastPage = $paginator->lastPage();
                        $start = max(1, $currentPage - 2);
                        $end = min($lastPage, $currentPage + 1);

                        // Adjust start and end to always show 4 buttons if possible
                        if ($currentPage == 1) {
                            $end = min(4, $lastPage);
                        } elseif ($currentPage == 2) {
                            $end = min(4, $lastPage);
                        } elseif ($currentPage == $lastPage) {
                            $start = max($lastPage - 3, 1);
                        } elseif ($currentPage == $lastPage - 1) {
                            $start = max($lastPage - 3, 1);
                        } else {
                            $start = max(1, $currentPage - 2);
                            $end = min($lastPage, $currentPage + 1);
                        }
                    ?>

                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($page >= $start && $page <= $end): ?>
                            <?php if($page == $currentPage): ?>
                                <li class="page-item shadow disabled"><a class="page-link active"><?php echo e($page); ?></a></li>
                            <?php else: ?>
                                <li class='page-item'><a class='page-link' href="<?php echo e($url); ?>"><?php echo e($page); ?></a></li>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            
            <?php if($paginator->hasMorePages()): ?>
                <li class="page-item"><a class="page-link"
                        href="<?php echo e($paginator->nextPageUrl()); ?>"><?php echo e(__('Next')); ?></a></li>
            <?php else: ?>
                <li class="page-item disabled"><a class="page-link"><?php echo e(__('Next')); ?></a></li>
            <?php endif; ?>
        </ul>
    </nav>
<?php endif; ?>
<?php /**PATH /home/echofit1/bdgamesbazar.xyz/core/resources/views/pagination.blade.php ENDPATH**/ ?>